/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more;

import com.pikachu.mod.illager_more.config.IllagerAdditionsConfig;
import com.pikachu.mod.illager_more.entities.ShogunEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public class CombatEvent {
    protected static final EntityDataAccessor<Boolean> IS_VOID = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public static void forceKnockback(LivingEntity attackTarget, float strength, double ratioX, double ratioZ, double knockbackResistanceReduction) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)attackTarget, (float)strength, (double)ratioX, (double)ratioZ);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        if (!((strength = (float)((double)strength * (1.0 - attackTarget.m_21133_(Attributes.f_22278_) * knockbackResistanceReduction))) <= 0.0f)) {
            attackTarget.f_19812_ = true;
            Vec3 vector3d = attackTarget.m_20184_();
            Vec3 vector3d1 = new Vec3(ratioX, 0.0, ratioZ).m_82541_().m_82490_((double)strength);
            attackTarget.m_20334_(vector3d.f_82479_ / 2.0 - vector3d1.f_82479_, attackTarget.m_20096_() ? Math.min(0.4, vector3d.f_82480_ / 2.0 + (double)strength) : vector3d.f_82480_, vector3d.f_82481_ / 2.0 - vector3d1.f_82481_);
        }
    }

    public static void addNewProjectile(Projectile projectile, CompoundTag compoundNBT, Level world, float rotation) {
        Projectile newProjectile = (Projectile)projectile.m_6095_().m_20615_(world);
        UUID uuid = newProjectile.m_20148_();
        newProjectile.m_20258_(compoundNBT);
        newProjectile.m_20084_(uuid);
        Vec3 vector3d = newProjectile.m_20184_().m_82524_((float)(Math.PI / (double)rotation));
        newProjectile.m_20256_(vector3d);
        float f = Mth.m_14116_((float)((float)vector3d.m_165925_()));
        newProjectile.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        newProjectile.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        newProjectile.f_19859_ = newProjectile.m_146908_();
        newProjectile.f_19860_ = newProjectile.m_146909_();
        if (newProjectile instanceof AbstractHurtingProjectile) {
            AbstractHurtingProjectile newDamagingProjectile = (AbstractHurtingProjectile)newProjectile;
            Vec3 newPower = new Vec3(newDamagingProjectile.f_36813_, newDamagingProjectile.f_36814_, newDamagingProjectile.f_36815_).m_82524_((float)(Math.PI / (double)rotation));
            newDamagingProjectile.f_36813_ = newPower.f_82479_;
            newDamagingProjectile.f_36814_ = newPower.f_82480_;
            newDamagingProjectile.f_36815_ = newPower.f_82481_;
        }
        world.m_7967_((Entity)newProjectile);
    }

    public static void AreaAttack(LivingEntity v, float range, float X, float Y, float Z, float arc, float damage, double DeltaY, double knockback_reduction, boolean throughArmor) {
        for (LivingEntity entityHit : v.f_19853_.m_45976_(LivingEntity.class, v.m_20191_().m_82377_((double)X, (double)Y, (double)Z))) {
            Mob mob;
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - v.m_20189_(), entityHit.m_20185_() - v.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = v.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - v.m_20189_()) * (entityHit.m_20189_() - v.m_20189_()) + (entityHit.m_20185_() - v.m_20185_()) * (entityHit.m_20185_() - v.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || v.m_7307_((Entity)entityHit) || entityHit == v || !(v instanceof Mob) || !(mob = (Mob)v).m_21574_().m_148306_((Entity)entityHit)) continue;
            int i = EnchantmentHelper.m_44914_((LivingEntity)v);
            if (i > 0) {
                entityHit.m_20254_(i * 4);
            }
            float attackKnockback = (float)v.m_21133_(Attributes.f_22282_);
            entityHit.f_19802_ = 0;
            float damages = (float)(v.m_21133_(Attributes.f_22281_) * (double)damage);
            if (v instanceof ShogunEntity) {
                Player player;
                ShogunEntity shogun = (ShogunEntity)v;
                damages = (entityHit instanceof Player ? (v.f_19853_.m_46791_().m_19028_() <= 2 ? 4.5f : 6.5f) * damage : damages) * (float)((Integer)IllagerAdditionsConfig.shogunAttackDamageMultiplier.get()).intValue();
                shogun.hitMobMap.putIfAbsent(entityHit, 0);
                if (entityHit instanceof Player && (player = (Player)entityHit).m_217043_().m_188503_(6) == 0 && player.m_21254_()) {
                    player.m_36384_(true);
                    damages = (float)((double)damages * 0.05);
                }
                double d = shogun.m_21133_(Attributes.f_22281_) * (double)entityHit.m_21233_() / Math.max(1789.875 - (double)((shogun.hitMobMap.get(entityHit) != null ? shogun.hitMobMap.get(entityHit) : 0) * 35), 25.0);
                if ((d = Math.max(d, (double)Math.min(shogun.hitMobMap.get(entityHit) != null ? (float)(shogun.hitMobMap.get(entityHit) * shogun.hitMobMap.get(entityHit)) * 0.1675f : 0.0f, v.f_19853_.m_46791_().m_19028_() > 2 ? 2.5f : 3.5f))) > 5.75) {
                    throughArmor = true;
                }
                damages = (float)((double)damages + d);
                shogun.hitMobMap.replace(entityHit, shogun.hitMobMap.get(entityHit), shogun.hitMobMap.get(entityHit) + 2 + shogun.m_217043_().m_188503_(4));
            }
            float hp = entityHit.m_21223_();
            if (throughArmor && !entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)v), damages)) {
                Player player;
                entityHit.f_19802_ = 0;
                entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)v).m_19380_(), damages * 0.05f);
                if (entityHit instanceof Player && (player = (Player)entityHit).m_21254_()) {
                    player.m_36384_(true);
                }
            } else {
                entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)v), damages);
            }
            if (entityHit.m_21223_() - 3.0f > hp && v instanceof ShogunEntity) {
                entityHit.m_21153_(hp - 1.5f);
            }
            v.m_21335_((Entity)entityHit);
            double ratioX = Mth.m_14031_((float)(v.m_146908_() * ((float)Math.PI / 180)));
            double ratioZ = -Mth.m_14089_((float)(v.m_146908_() * ((float)Math.PI / 180)));
            entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)v), damage);
            CombatEvent.forceKnockback(entityHit, attackKnockback * 0.8f, ratioX, ratioZ, knockback_reduction);
            entityHit.m_20256_(entityHit.m_20184_().m_82520_(0.0, DeltaY, 0.0));
        }
    }

    public static boolean checkAreaEntity(LivingEntity v, LivingEntity entity, float range, float X, float Y, float Z, float arc) {
        boolean b = false;
        for (LivingEntity entityHit : v.f_19853_.m_45976_(LivingEntity.class, v.m_20191_().m_82377_((double)X, (double)Y, (double)Z))) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - v.m_20189_(), entityHit.m_20185_() - v.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = v.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - v.m_20189_()) * (entityHit.m_20189_() - v.m_20189_()) + (entityHit.m_20185_() - v.m_20185_()) * (entityHit.m_20185_() - v.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || entityHit != entity) continue;
            b = true;
            break;
        }
        return b;
    }

    public static List<LivingEntity> getAreaEntity(LivingEntity v, float range, float X, float Y, float Z, float arc) {
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
        for (LivingEntity entityHit : v.f_19853_.m_45976_(LivingEntity.class, v.m_20191_().m_82377_((double)X, (double)Y, (double)Z))) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - v.m_20189_(), entityHit.m_20185_() - v.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = v.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - v.m_20189_()) * (entityHit.m_20189_() - v.m_20189_()) + (entityHit.m_20185_() - v.m_20185_()) * (entityHit.m_20185_() - v.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f)) continue;
            entities.add(entityHit);
        }
        return entities;
    }

    public static Vec3 getOffsetPos(Entity entity, double offsetX, double offsetY, double offsetZ, float rotation) {
        Vec3 vector3d = new Vec3(offsetZ, offsetY, offsetX).m_82524_(-rotation * ((float)Math.PI / 180) - 1.5707964f);
        return entity.m_20182_().m_82520_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }
}

